// acf_igor_bin.cpp : Defines the entry point for the console application.
//

// autocorrelation.cpp : Defines the entry point for the DLL application.
//

// stringbasedcalcualtion.cpp : Defines the entry point for the DLL application.
//

/*
	XFUNC3.h -- equates for XFUNC3 XOP
 XFUNC3 custom error codes 
#define REQUIRES_IGOR_200 1 + FIRST_XOP_ERR
#define UNKNOWN_XFUNC 2 + FIRST_XOP_ERR
#define NO_INPUT_STRING 3 + FIRST_XOP_ERR
Prototypes 
HOST_IMPORT void main(IORecHandle ioRecHandle); */ 

//	XFUNC3.c -- illustrates Igor external string functions. 

#include "XOPStandardHeaders.h"			// Include ANSI headers, Mac headers, IgorXOP.h, XOP.h and XOPSupport.h
#include "autocorrelation.h"
#include <stdio.h>
#include "stdlib.h"
//#include "stdafx.h"
//#include <fstream>
#include "string.h"
#include "TIFFconstants.h"
#include <iostream>
#include <fstream>
#include <assert.h>
#include <errno.h>
#include "stdafx.h"
#include "atlstr.h"

#define SWAP_4(memblock, k) \
	{ char a = memblock[k]; \
	char b = memblock[k+1]; \
	char c = memblock[k+2]; \
	char d = memblock[k+3]; \
	memblock[k]=d; \
	memblock[k+1]=c; \
	memblock[k+2]=b; \
	memblock[k+3]=a; }

#define SWAP_2(memblock, k) \
	{ char a = memblock[k]; \
	char b = memblock[k+1]; \
	memblock[k]=b; \
	memblock[k+1]=a; }

using namespace std;

double *timestamps;


/** Convert between Julian day numbers and the day/month/year format **/
void JulianToYMD(unsigned long julian, unsigned short& year, unsigned char& month, unsigned char& day)
{
	long	a, b, c, d, e, alpha;
	long	z = julian + 1;

	// dealing with Gregorian calendar reform
	if (z < 2299161L) {
		a = z;
	} else {
		alpha = (long) ((z - 1867216.25) / 36524.25);
		a = z + 1 + alpha - alpha / 4;
	}

	b = ( a > 1721423L ? a + 1524 : a + 1158 );
	c = (long) ((b - 122.1) / 365.25);
	d = (long) (365.25 * c);
	e = (long) ((b - d) / 30.6001);

	day = (unsigned char)(b - d - (long)(30.6001 * e));
	month = (unsigned char)((e < 13.5) ? e - 1 : e - 13);
    year = (short)((month > 2.5 ) ? (c - 4716) : c - 4715);
}

unsigned long YMDToJulian(unsigned short year, unsigned char month, unsigned char day)
{
	short	a, b = 0;
	short	work_year = year;
	short	work_month = month;
	short	work_day = day;

	// correct for negative year
	if (work_year < 0) {
		work_year++;
	}

	if (work_month <= 2) {
		work_year--;
		work_month += (short)12;
	}

	// deal with Gregorian calendar
	if (work_year*10000. + work_month*100. + work_day >= 15821015.)	{
		a = (short)(work_year/100.);
		b = (short)(2 - a + a/4);
	}

	return	(long) (365.25*work_year) +
		   	(long) (30.6001 * (work_month+1)) +
			work_day + 1720994L + b;
}


#include "XOPStructureAlignmentTwoByte.h"	// All structures passed to Igor are two-byte aligned.
struct xstrcatParams  {
	waveHndl w1;
	waveHndl w;
//double corrpoints_entry;
	//double position2;
double channel2;
double channel1;	//double position1;
	double bin;
	double minimumvalue;
	double number_jagadish2;
	double number_jagadish1;
	Handle str_jagadish4;
	Handle str_jagadish3;
	Handle str_jagadish2;
	Handle str_jag_sd;
	Handle result;
};
typedef struct xstrcatParams xstrcatParams;
#include "XOPStructureAlignmentReset.h"

static int xstrcat(xstrcatParams* p)				/* str1 = xstrcat(str2, str3) */
{
	
	waveHndl wavH;
	wavH = p->w;
	long npnts;
	float *fDataPtr;		// Pointer to single-precision floating point wave data.
	double *dDataPtr;
	npnts = WavePoints(wavH);	
	int *array;
array = (int *)malloc((npnts)*sizeof(float));
switch (WaveType(wavH)) {
		case NT_FP32:
			fDataPtr = (float*)WaveData(wavH);	// DEREFERENCE - we must not cause heap to scramble.
			for (int i = 0; i < npnts; i++) {
				array[i] = *fDataPtr;
				//*fDataPtr += 1.0;

				fDataPtr += 1;
			}
			break;

		case NT_FP64:
			dDataPtr = (double*)WaveData(wavH);	// DEREFERENCE - we must not cause heap to scramble.
			for (int i = 0; i < npnts; i++) {
				array[i] = *dDataPtr;
				//*dDataPtr += 1.0;
				//a = *dDataPtr;
				dDataPtr += 1;
			}
			break;
	}

//	FILE *trial = fopen("array.txt", "w");
// 
//	if(trial  == (FILE *) NULL)
//		printf("\nFailed to open the file");
//	else
//		printf("\nSuccessfully created file");
//	
//for (int i = 0; i<npnts; i++)
//
//	fprintf(trial , "%d\n", array[i]);
//
//
//	fclose(trial);

	waveHndl wavH1;
	wavH1 = p->w1;
	//long npnts;
	float *fDataPtr1;		// Pointer to single-precision floating point wave data.
	double *dDataPtr1;
	//npnts = WavePoints(wavH);	
	int *array1;
array1 = (int *)malloc((npnts)*sizeof(float));
switch (WaveType(wavH1)) {
		case NT_FP32:
			fDataPtr1 = (float*)WaveData(wavH1);	// DEREFERENCE - we must not cause heap to scramble.
			for (int i = 0; i < npnts; i++) {
				array1[i] = *fDataPtr1;
				//*fDataPtr += 1.0;

				fDataPtr1 += 1;
			}
			break;

		case NT_FP64:
			dDataPtr1 = (double*)WaveData(wavH1);	// DEREFERENCE - we must not cause heap to scramble.
			for (int i = 0; i < npnts; i++) {
				array1[i] = *dDataPtr1;
				//*dDataPtr += 1.0;
				//a = *dDataPtr;
				dDataPtr1 += 1;
			}
			break;
	}
//FILE *trial1 = fopen("array1.txt", "w");
// 
//	if(trial1  == (FILE *) NULL)
//		printf("\nFailed to open the file");
//	else
//		printf("\nSuccessfully created file");
//	
//for (int i = 0; i<npnts; i++)
//
//	fprintf(trial1 , "%d\n", array1[i]);
//
//
//	fclose(trial1);

	Handle str1;						/* output handle */
	long len2, len3,len_conv, len_conv1, len_sd, len_conv_sd;
											long len4, len_conv2;
	int err=0;
	//char* queen_jagadish ;
	//char* vulture_jagadish;
											//char* king_jagadish;
	
	long lengthtrial, lengthtrial1;
											long lengthtrial2;
	
int hState, hState1;
											int hState2;



	
	
	str1 = NIL;	

	
	len2 = GetHandleSize(p->str_jagadish2);		/* length of string 2 */
	len3 = GetHandleSize(p->str_jagadish3);
		len4 = GetHandleSize(p->str_jagadish4);
		len_sd = GetHandleSize(p->str_jag_sd);/* length of string 3 */
	str1 = NewHandle(len2 + len3 + len4+len_sd);	


	memcpy(*str1, *p->str_jagadish2, len2);
	memcpy(*str1+len2, *p->str_jagadish3, len3);
	memcpy(*str1+len2+ len3, *p->str_jagadish4, len4);

	memcpy(*str1+len2+ len3+len4, *p->str_jag_sd, len_sd);

				int start = p ->number_jagadish1;
					int end = p ->number_jagadish2 ;

	int rowvariable = 0;
	struct IFH ifh;
	struct tiffheader tiffh;
	void *m_data;
	
	len_conv = GetHandleSize(p->str_jagadish2);
char trialstring[1024];
if (len_conv> (sizeof(trialstring)-1))
return STR_TOO_LONG;
GetCStringFromHandle(p->str_jagadish2, trialstring, len_conv);
assert(trialstring != NULL);


len_conv1 = GetHandleSize(p->str_jagadish3);
char trialstring1[1024];
if (len_conv1 > (sizeof(trialstring1)-1))
return STR_TOO_LONG;
GetCStringFromHandle(p->str_jagadish3, trialstring1, len_conv1);
assert(trialstring1 != NULL);

len_conv2 = GetHandleSize(p->str_jagadish4);
char trialstring2[1024];
if (len_conv2> (sizeof(trialstring2)-1))
return STR_TOO_LONG;
GetCStringFromHandle(p->str_jagadish4, trialstring2, len_conv2);
assert(trialstring1 != NULL);


len_conv_sd = GetHandleSize(p->str_jag_sd);
char trialstring3[1024];
if (len_conv_sd> (sizeof(trialstring3)-1))
return STR_TOO_LONG;
GetCStringFromHandle(p->str_jag_sd, trialstring3, len_conv_sd);
assert(trialstring1 != NULL);

	FILE *triala = fopen(trialstring2,"wb");
	
	/* int akl= 2;
	//fwrite(triala, sizeof( int), 1, triala);
*/
	FILE * f = fopen(trialstring, "rb");
	assert(f && "couldn't open file");
	fseek(f, SEEK_SET, SEEK_END);
	__int64 filesize = ftell(f);
	assert(filesize > 0);
	if(filesize > 1E9)
		return NOMEM;


	m_data = malloc((size_t)filesize);
	if (m_data == NULL)
		return NOMEM; 	// FIX_ME: bogus cast. 2004121 mortene.
	assert(m_data);

	fseek(f, 0, 0);
	size_t gotnrbytes =	fread(m_data, 1, (size_t)filesize, f);
	assert(gotnrbytes == filesize);

	int r = fclose(f);
	assert(r == 0);

	
	// magic_number and header_length
	(void)memcpy(&ifh, m_data, IFH_SIZE);
	printf("byteorder = 0x%04x\n",ifh.byteorder);
	cout << "byteorder: " << ifh.byteorder << endl;


	if (ifh.byteorder == TIFF_LITTLE)
		cout << "LITTLE endian"<< endl;
	else if (ifh.byteorder == TIFF_BIG)
		cout << "BIG endian"<< endl;

	assert(ifh.byteorder == TIFF_LITTLE);//STK files MUST have little-endian byte order
	cout << "magic_number: " << ifh.magic_number << endl;
	
	//assert(ifh.magic_number == TIFF_MAGIC_NUMBER);
	char * memblock = (char *)&ifh;
	bool isSwapRequired = false;
	if (ifh.magic_number != TIFF_MAGIC_NUMBER)
	{
		isSwapRequired = true;
		if (isSwapRequired) {
			SWAP_2(memblock,0);
			SWAP_2(memblock,2);
			SWAP_4(memblock,4);
		}
	}
	assert(ifh.magic_number == TIFF_MAGIC_NUMBER);

	cout << "magic_number: " << ifh.magic_number << endl;
	int nextIFDoffset = -1;
	

	long long int offset;
	
	offset = ifh.firstIFDoffset;
	int  counter = 0;
	while ( offset > 0 )

{
		counter = counter++;
		//cout << "IDF offset: " << offset << endl;
		
		short	num_directory_entries;
			//if(counter>0)
			//offset = newoffset + update*(counter-1);
			memcpy( &num_directory_entries, (unsigned char *)m_data + offset, sizeof( short ));
	/*	cout << "# of directory entries: " << num_directory_entries << endl;*/

		long long int	addr = offset + 2;
		for ( int i = 0; i < num_directory_entries; i++ ) {
			bool isValue=false;
			IFD_entry	ifd;
			memcpy( &ifd, (unsigned char *)m_data + addr, IFD_ENTRY_SIZE );
	
				if (ifd.count*IFD_TYPE_SIZE[ifd.type]>4){
			/*cout << "OFFSET: " << ifd.offset<< endl;	*/
		}else{
			/*cout << "VALUE: " << ifd.value<< endl;*/
			isValue = true;
		}
			switch (ifd.tag){
			
			case IFD_IMAGE_WIDTH:
				tiffh.numRows = ifd.value;
				/*cout << "  rows " << tiffh.numRows;*/
			break;
			case IFD_IMAGE_LENGTH:
				tiffh.numCols = ifd.value;
			break;
			}

			addr += IFD_ENTRY_SIZE;
		}

		
	
		memcpy( &offset, (unsigned char *)m_data + addr, sizeof( int ));
		
		}
	//tiffh.BitsPerSample = 8;
unsigned short **intensity_array, **final_array;

printf("\nThe value of counter = %d", counter);
float *wacftot, *wsemtot ;
int abcde, abcdef;
	
	intensity_array = (unsigned short **)malloc((counter ) * sizeof(unsigned short *));
	if( intensity_array == (unsigned short **) NULL)
		printf("\nFailed to allocate the rows of the array");
	else 
		printf("\nSucessfully allocated the rows of the array");

	for ( abcdef = 0; abcdef < counter ; abcdef++)
	{
		intensity_array[abcdef] = (unsigned short *)malloc (tiffh.numCols*tiffh.numRows*sizeof(unsigned short));
		if ( intensity_array[abcdef] == (unsigned short *)NULL)
		{
			printf("\nFailed to allocate the columns of the array");
			printf("\nThe value of n is %d", abcdef);
			break;
		}
	}
	if ( abcdef == counter)
		printf("\n the entire array is allocated");
	else
		printf("\nThe entire array is not allocated");
	//int a;
	//printf("\nThe number of files is %d", counter);
//scanf("%d", &a);


	final_array = (unsigned short **)malloc((end- start + 1 ) * sizeof(unsigned short *));
	if( final_array == (unsigned short **) NULL)
		printf("\nFailed to allocate the rows of the array");
	else 
		printf("\nSucessfully allocated the rows of the array");

	for ( abcdef = 0; abcdef < end - start+ 1; abcdef++)
	{
		final_array[abcdef] = (unsigned short *)malloc (tiffh.numCols*tiffh.numRows*sizeof(unsigned short));
		if ( final_array[abcdef] == (unsigned short *)NULL)
		{
			printf("\nFailed to allocate the columns of the array");
			printf("\nThe value of n is %d", abcdef);
			break;
		}
	}
	if ( abcdef == end -start + 1)
		printf("\n the entire array is allocated");
	else
		printf("\nThe entire array is not allocated");


	//cout << "exposureTime = "<< exposureTime << endl;
	//int volSize = tiffh.numRows*tiffh.numCols*tiffh.numPlanes*tiffh.bytespervoxel;
	
	
		
//assert(volSize==tiffh.stripByteCounts[0]);
	//(void)memcpy(m_data, (unsigned char *) m_data+tiffh.stripOffsets[0], volSize);

	//int planeSize = tiffh.numRows * tiffh.numCols;

//FILE *fw = fopen(outfile, "w");


	offset = ifh.firstIFDoffset;
FILE *fp = fopen(trialstring1, "wb");

FILE *fp1 = fopen(trialstring3, "wb");

while ( offset > 0 )
{
		
		//cout << "IDF offset: " << offset << endl;
		
		short	num_directory_entries;
			//if(counter>0)
			//offset = newoffset + update*(counter-1);
			memcpy( &num_directory_entries, (unsigned char *)m_data + offset, sizeof( short ));
	/*	cout << "# of directory entries: " << num_directory_entries << endl;*/

		long long int	addr = offset + 2;
		for ( int i = 0; i < num_directory_entries; i++ ) {
			bool isValue=false;
			IFD_entry	ifd;
			memcpy( &ifd, (unsigned char *)m_data + addr, IFD_ENTRY_SIZE );
			/*cout << "  tag: " << ifd.tag;
			cout << "  hello\n" ;
			cout << "  type: " << ifd.type << "(" << IFD_TYPE_NAME[ ifd.type ] << ") ";
			cout << "  count: " << ifd.count << endl;*/

				if (ifd.count*IFD_TYPE_SIZE[ifd.type]>4){
			/*cout << "OFFSET: " << ifd.offset<< endl;	*/
		}else{
			/*cout << "VALUE: " << ifd.value<< endl;*/
			isValue = true;
		}
				switch (ifd.tag){
			
			case IFD_IMAGE_WIDTH:
				tiffh.numRows = ifd.value;
				/*cout << "  rows " << tiffh.numRows;*/
			break;
			case IFD_IMAGE_LENGTH:
				tiffh.numCols = ifd.value;
			break;


			case IFD_BITS_PER_SAMPLE:
				tiffh.BitsPerSample = ifd.value;
				tiffh.SamplesPerPixel = ifd.count;
				tiffh.bytespervoxel = tiffh.BitsPerSample/8;// * tiffh.SamplesPerPixel /8;
			break;
			
			case IFD_IMAGE_DESCRIPTION:
				tiffh.imageDescription =  new char[ifd.count];
				(void)memcpy(tiffh.imageDescription, (char *)m_data+ifd.offset,ifd.count);
			break;
			

			case IFD_STRIP_OFFSETS:
				{	
					/*cout << "----StripOffsets----"<<endl;*/
					int entrycount = ifd.count;
					tiffh.stripOffsets = new int[entrycount];
					for (int j=0; j<entrycount; j++)
					{
						if (isValue){
							tiffh.stripOffsets[j] = ifd.value;
						}else{
						(void)memcpy(&tiffh.stripOffsets[j], 
									(unsigned char *)m_data+ifd.offset+j*IFD_TYPE_SIZE[ifd.type], 
									IFD_TYPE_SIZE[ifd.type]);
						}
						//cout << tiffh.stripOffsets[j] << " " ;
					}
					//cout << endl;
				}
			break;
			/*case IFD_ZResolution:
				tiffh.ZResolution = ifd.value;
			break;
			*/
			
			case IFD_ROWS_PER_STRIP:
				tiffh.rowsPerStrip = ifd.value;
			break;
			case IFD_STRIP_BYTE_COUNTS:
				{	
					//cout << "----StripByteCounts----"<<endl;
					int entrycount = ifd.count;
					tiffh.stripByteCounts = new int[entrycount];
					for (int j=0; j<entrycount; j++)
					{
						if (isValue){
								tiffh.stripByteCounts[j] = ifd.value;
						}else{
							(void)memcpy(&tiffh.stripByteCounts[j], 
									(unsigned char *)m_data+ifd.offset+j*IFD_TYPE_SIZE[ifd.type], 
									IFD_TYPE_SIZE[ifd.type]);
						}
						//cout << tiffh.stripByteCounts[j] << " " ;
					}
					//cout << endl;
				}
			break;
		
		
		
		
				}
		
			
			addr += IFD_ENTRY_SIZE;
		}
			memcpy( &offset, (unsigned char *)m_data + addr, sizeof( int ));	
	//assert(counter==counter1);
	//tif file solis
	//int volSize = tiffh.numRows*tiffh.numCols*tiffh.bytespervoxel;
(void)memcpy(m_data, (unsigned char *) m_data+tiffh.stripOffsets[0], tiffh.numRows*tiffh.numCols*tiffh.bytespervoxel);
//int planeSize = tiffh.numRows * tiffh.numCols;
	//char *outfile1 = "C:\lagtime.txt";
	//FILE *fwtime = fopen(outfile1, "w");
	

	//cout << "exposureTime = "<< exposureTime << endl;

	//for (int iz=0; iz<tiffh.numPlanes; iz++)

		////cout << "============Plane "<< (iz+1) << "==============" << endl;
		//double timestamp = timestamps[iz];
		//cout << "exposureTime = "<< exposureTime << endl;
		////cout << timestamp << " ";
		//printf("%.5f ", timestamp );
		//fprintf( fwtime, "%.5f\n", timestamp );
	
		for (int iy=0; iy<tiffh.numCols; iy++)
		{
			for (int ix=0; ix<tiffh.numRows; ix++)
			{
				int index = iy*tiffh.numRows + ix;
				unsigned short c = (tiffh.bytespervoxel==1 ? ((unsigned char *)m_data)[index] : ((unsigned short *)m_data)[index]);
				//cout << c << " ";
				intensity_array[rowvariable][iy*tiffh.numRows + ix] = c;
					//fprintf( fw, "%u ", intensity_array[rowvariable][iy*tiffh.numRows + ix] );
			
			}
		}
		//cout << endl;
		//fprintf(fw, "\n");

	
		//memcpy( &offset, (unsigned char *)m_data + addr, sizeof( int ));
		rowvariable++;

	}
	
	//int ii, k ;
	//float timestep,lagtime[72],a, b;
	//printf("\nEnter the value of timestep");
	//scanf("%f", &timestep);
	//timestep = p->timestep;
	for ( int i = 0; i < end - start +1; i++)
	{
		for (int j = 0; j< tiffh.numCols*tiffh.numRows; j++)
		{
			final_array[i][j] = intensity_array[start - 1 + i][j];
			//fprintf( fw, "%u ", final_array[i][j] );
		}
		//fprintf(fw, "\n");
	}
	/*
unsigned short min;
min =  intensity_array[0][0];
for ( abcdef = 0; abcdef < (endPlane - startPlane) ; abcdef++)
{
	for (abcde = 0; abcde < tiffh.numCols*tiffh.numRows; abcde++)
	{
		if ( intensity_array[abcdef][abcde] < min)
			min = intensity_array[abcdef][abcde];
	}
}
for ( int i = 0; i < end - start +1; i++)
	{
		for (int j = 0; j< tiffh.numCols*tiffh.numRows; j++)
		{
			final_array[i][j] = intensity_array[start - 1 + i][j];
			//fprintf( fw, "%u ", final_array[i][j] );
		}
		//fprintf(fw, "\n");
	}
printf("\nTHE minimum value is %d", min);
*/
	for (abcdef = 0; abcdef < end - start +1; abcdef++)
{
	for ( abcde = 0; abcde < tiffh.numCols*tiffh.numRows; abcde++)
		final_array[abcdef][abcde] =  final_array[abcdef][abcde] - p ->minimumvalue;
}


int sizeofbox = p->bin;
int channel2 = p ->channel2;
int channel1 = p->channel1;
	/*wacftot = functionreturningautocorrelation( tiffh.numPlanes,tiffh.numCols,tiffh.numRows,sizeofbox, **finalarray);*/
//		printf("%d %d", (endPlane - startPlane), tiffh.numCols*tiffh.numRows);

		long long int j,v;
		int numberofpoints,number_of_pixels_in_image, pixelposition1,pixelposition2;
	 long long int *twave,*twave2,*twave3,*tpwave,*tpwave2,*tpwave3, windex;
	 float btmp, atmp, itmp1, itmp2;
long int *towrite;
//int noofloops;
	 number_of_pixels_in_image = tiffh.numCols * tiffh.numRows;
	FILE *filecontainingintensity, *filecontainingautocorrelation;
	 numberofpoints = ( int)((end - start +1)/2);

	 char str[33];
	wacftot = (float *)malloc(((channel2-1)*channel1/2+channel1)*sizeof(float));
	wsemtot = (float *)malloc(((channel2-1)*channel1/2+channel1)*sizeof(float));

	twave = (  long long  int *)calloc(end - start +1, sizeof(long  long  int ));
	if( twave == (long long  int *)NULL)
		printf("\n Failed to allocate twave");

		towrite = (  long  int *)calloc(end - start +1, sizeof(long    int ));
	if( towrite == (long   int *)NULL)
		printf("\n Failed to allocate twave");

	tpwave = (  long long  int *)calloc(end - start +1, sizeof(long  long  int ));
	if( tpwave == (long long  int *)NULL)
		printf("\n Failed to allocate tpwave");

	
	twave3 = (long long int *)calloc(end - start +1, sizeof( long long   int));
	if( twave3 == (  long long int *)NULL)
		printf("\n Failed to allocate twave3");

	tpwave3 = (long long int *)calloc(end - start +1, sizeof( long long   int));
	if( tpwave3 == (  long long int *)NULL)
		printf("\n Failed to allocate tpwave3");


    twave2 = (  long long  int *)calloc(numberofpoints , sizeof(  long long int));
	if( twave2 == (long   long  int *)NULL)
		printf("\n Failed to allocate twave2");

	tpwave2 = (  long long  int *)calloc(numberofpoints , sizeof(  long long int));
	if( tpwave2 == (long   long  int *)NULL)
		printf("\n Failed to allocate tpwave2");

	printf("\nCompleted the declaration");

int counteraa = 0;
		for (int y = 0; y < npnts; y++)
{
	pixelposition1 = array[y];
	pixelposition2 = array1[y];
//for ( int  i8 = 0; i8< tiffh.numCols/sizeofbox;  i8++)
//{
//for (int k8 = 0; k8< tiffh.numRows/sizeofbox; k8++)
//{
	counteraa++;
	
	printf("a\n");

	numberofpoints =  (int) ((end- start+1)/2);
	printf("b\n");
	for ( int i2 = 0; i2 < (end - start+1) ; i2++)
	{
		twave3[i2] = 0;
		tpwave3[i2] = 0 ;
		
		twave[i2] = 0;
		tpwave[i2] = 0 ;
	}
printf("kkk\n");
	for ( int i6 = 0; i6 < numberofpoints ; i6++)
	{
		twave2[i6] = 0;
		tpwave2[i6] = 0 ;
	}
	for ( int i4 = 0; i4 < ((channel2-1)*channel1/2+channel1) ; i4++)
		wacftot[i4]= 0;

windex = 0;



		for ( int i3= 0; i3 < sizeofbox; i3++)
	{
		for (int j3= 0; j3 < sizeofbox ; j3++)
		{
			for (int s1 = 0; s1 < (end - start+1); s1++)
			{
				twave[s1] = twave[s1] + final_array[s1][pixelposition1 + i3*tiffh.numRows + j3];
				//printf( "%d\n", twave[s1]);
			tpwave[s1] = tpwave[s1] + final_array[s1][pixelposition2 +  i3*tiffh.numRows + j3];
			towrite[s1] = tpwave[s1];
			}
		}
	}
fwrite( towrite, sizeof( long int), (end-start+1 ), triala);

fseek( triala, counteraa*(end-start+1 )*sizeof( long int),SEEK_SET);
		
			int k=0;
	do
	{
		int i =0;
		atmp = 0;
		itmp1 =0;
		itmp2 = 0;
		btmp = 0;		
		do
		{
			atmp  = atmp + twave[i] * tpwave[i+k] ;
			//printf("%d\n", tpwave[i+k]);
			btmp = btmp + twave[i] * tpwave[i+k]*twave[i] * tpwave[i+k] ;
			itmp1 = itmp1 + twave[i];
			itmp2 = itmp2 + tpwave[i+k];
			//printf("\t%d" ,  itmp1 );
			i = i+1;
			//printf("\n%d\t%d\t%d" , itmp1, atmp,  itmp2);
		}
		while (i < ((end - start+1) - k));
		wacftot[windex] =  (float) (atmp)/ (float)(  itmp1 *   itmp2)* (float) ((end - start+1) - k);
		wsemtot[windex] = sqrt( ( btmp/((end - start+1) - k) -  (atmp/((end - start+1) - k))* (atmp/((end - start+1) - k))))/ itmp1/ itmp2* ((end - start+1) - k)* ((end - start+1) - k)/ sqrt((float)((end - start+1)-k)) ;
		windex = windex + 1;
		k = k+ 1;
		//printf("\nHi");
	}
	while (k <= (channel1-1));
	int i;
	v =1;
	do
	{
		if (v == 1)
		{
				for ( i= 0; i<(end - start+1); i++)
				{
					twave3[i] = twave[i];
					tpwave3[i] = tpwave[i];
					
				}
		}
		else
		{
			for ( i= 0; i< numberofpoints; i++)
				{
				twave3[i] = twave2[i];
				tpwave3[i] = tpwave2[i];
				// the other values must be lost.
				//printf("%d", twave3[i]);
				
			}
			numberofpoints = numberofpoints/2;
			twave2 = ( long long  int *)realloc(twave2, numberofpoints * sizeof(long long  int));
			tpwave2 = ( long long  int *)realloc(tpwave2, numberofpoints * sizeof(long long  int));
			
		}
		for ( i = 0; i< numberofpoints; i++)
		{
			twave2[i] = twave3[(2*i)] + twave3[(2*i) + 1];
			tpwave2[i] = tpwave3[(2*i)] + tpwave3[(2*i) + 1];
			//printf("%d", twave2[i]);
		}
		twave3 = (long long int *)realloc(twave3, numberofpoints * sizeof (long  long int));
		tpwave3 = (long long int *)realloc(tpwave3, numberofpoints * sizeof (long  long int));
		k=0;
		do
		{
			i =0;
			atmp = 0;
			itmp1 = 0;
			itmp2 = 0;
			btmp =0;
			do
			{
				atmp = atmp + twave2[i]*tpwave2[i+k+channel1/2];
				btmp = btmp + twave2[i]* twave2[i]* tpwave2[i+k+channel1/2]*tpwave2[i+k+channel1/2];
				itmp1 = itmp1 + twave2[i];
				itmp2 = itmp2 + tpwave2[i+k+channel1/2];
				i = i+1;
			}
			while ( i < (numberofpoints- k-channel1/2));

			wacftot[windex] = (float) atmp/( (float) itmp1*  (float) itmp2)* (float)(numberofpoints - k - channel1/2);
			//printf("%d", windex);
			wsemtot[windex] =sqrt(( btmp/(numberofpoints- k-channel1/2) -  (atmp/(numberofpoints- k-channel1/2))* (atmp/(numberofpoints- k-channel1/2))))/ itmp1/ itmp2* (numberofpoints- k-channel1/2)* (numberofpoints- k-channel1/2)/ sqrt((float)(numberofpoints- k-channel1/2)) ; 
			windex = windex + 1;
			k = k+1;
			//printf("\ncheckforlooprunning3");
		}
		while (k<channel1/2);

		v = v+1;
		}
	while (v < channel2);
	/*printf("Checking for the proper");*/
	twave3 = (long  long int *)realloc(twave3,(end - start+1)*sizeof(long long int));
	twave2 = (long long int *)realloc(twave2, ((end - start+1)/2)*sizeof(long long int));
	tpwave3 = (long  long int *)realloc(tpwave3, (end - start+1)*sizeof(long long int));
	tpwave2 = (long long int *)realloc(tpwave2, ((end - start+1)/2)*sizeof(long long int));
	fwrite(wacftot, sizeof(float), ((channel2-1)*channel1/2+channel1), fp);
fwrite(wsemtot, sizeof(float), ((channel2-1)*channel1/2+channel1), fp1);
fseek(fp, counteraa*((channel2-1)*channel1/2+channel1)*sizeof(float), SEEK_SET);	
fseek(fp1, counteraa*((channel2-1)*channel1/2+channel1)*sizeof(float), SEEK_SET);	

	}
fclose(fp);
fclose(triala);
fclose(fp1);
	
//fclose(fpint);
done:
	if (p->str_jagadish2)
		DisposeHandle(p->str_jagadish2);			/* we need to get rid of input parameters */
	if (p->str_jagadish3)
		DisposeHandle(p->str_jagadish3);			/* we need to get rid of input parameters */
	p->result = str1;
	if(m_data != NULL)
		free(m_data);
	if(twave !=NULL)
		free(twave);
	if(tpwave != NULL)
		free(tpwave);
	if(twave3 !=NULL)
		free(twave3);
	if(tpwave3 != NULL)
		free(tpwave3);
	if(twave2 !=NULL)
		free(twave2);
	if(tpwave2 != NULL)
		free(tpwave2);
	return(err);
	//return(err);
}


/*
static long RegisterFunction()
{
	return((long)xstrcat);	
	}
//	XOPEntry() 	This is the entry point from the host application to the XOP 
//for all messages after the 	INIT message. 

static void XOPEntry(void)
{	
	long result = RegisterFunction();
	SetXOPResult(result);
}

/*	main(ioRecHandle)

	This is the initial entry point at which the host application calls XOP.
	The message sent by the host must be INIT. 	main() does any necessary
	initialization and then sets the XOPEntry field of the
	ioRecHandle to the address to be called for future messages.


HOST_IMPORT void main(IORecHandle ioRecHandle)
{	
	XOPInit(ioRecHandle);		/* do standard XOP initialization 
	SetXOPEntry(XOPEntry);		/* set entry point for future calls 

	if (igorVersion < 200)
		SetXOPResult(REQUIRES_IGOR_200);
	else
		SetXOPResult(0L);
}

/*/

static long
RegisterFunction()
{
	int funcIndex;

	/*	NOTE:
		Most XOPs should return a result of NIL in response to the FUNCADDRS message.
		See XOP manual "Restrictions on Direct XFUNCs" section.
	*/

	funcIndex = GetXOPItem(0);		/* which function invoked ? */
	switch (funcIndex) {
		case 0:						/* str1 = xstrcat0(str2, str3) */
			return((long)xstrcat);	/* this uses the direct call method */
			break;
		case 1:						/* str1 = xstrcat1(str2, str3) */
			return(NIL);			/* this uses the message call method */
			break;
	}
	return(NIL);
}

static int
DoFunction()
{
	int funcIndex;
	void *p;				/* pointer to structure containing function parameters and result */
	int err;				/* error code returned by function */

	funcIndex = GetXOPItem(0);		/* which function invoked ? */
	p = (void *)GetXOPItem(1);		/* get pointer to params/result */
	switch (funcIndex) {
		case 1:						/* str1 = xstrcat2(str2, str3) */
//			err = xstrcat(p);
			break;
		default:
			err = UNKNOWN_XFUNC;
			break;
	}
	return(err);
}

/*	XOPEntry()

	This is the entry point from the host application to the XOP for all messages after the
	INIT message.
*/

static void
XOPEntry(void)
{	
	long result = 0;

	switch (GetXOPMessage()) {
		case FUNCTION:								/* our external function being invoked ? */
			result = DoFunction();
			break;
			
		case FUNCADDRS:
			result = RegisterFunction();
			break;
	}
	SetXOPResult(result);
}

/*	main(ioRecHandle)

	This is the initial entry point at which the host application calls XOP.
	The message sent by the host must be INIT.
	main() does any necessary initialization and then sets the XOPEntry field of the
	ioRecHandle to the address to be called for future messages.
*/

HOST_IMPORT void
main(IORecHandle ioRecHandle)
{	
	XOPInit(ioRecHandle);							/* do standard XOP initialization */
	SetXOPEntry(XOPEntry);							/* set entry point for future calls */

	if (igorVersion < 200)
		SetXOPResult(REQUIRES_IGOR_200);
	else
		SetXOPResult(0L);
}



